<?php

// Fichier autoload.php manuel pour Dompdf (sans Composer)
// Charge les classes de Dompdf et ses dépendances depuis dompdf-master

$root = __DIR__ . '/../dompdf-master';  // Ajustez ce chemin si nécessaire

spl_autoload_register(function ($class) use ($root) {
    // Pour Dompdf\
    if (0 === strpos($class, 'Dompdf\\')) {
        $path = substr($class, strlen('Dompdf\\'));
        $file = $root . '/src/' . str_replace('\\', '/', $path) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }

    // Pour FontLib\ (php-font-lib)
    if (0 === strpos($class, 'FontLib\\')) {
        $path = substr($class, strlen('FontLib\\'));
        $file = $root . '/lib/php-font-lib/src/FontLib/' . str_replace('\\', '/', $path) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }

    // Pour Svg\ (php-svg-lib)
    if (0 === strpos($class, 'Svg\\')) {
        $path = substr($class, strlen('Svg\\'));
        $file = $root . '/lib/php-svg-lib/src/Svg/' . str_replace('\\', '/', $path) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }

    // Pour Sabberworm\CSS\ (php-css-parser)
    if (0 === strpos($class, 'Sabberworm\\CSS\\')) {
        $path = substr($class, strlen('Sabberworm\\CSS\\'));
        $file = $root . '/lib/php-css-parser/lib/Sabberworm/CSS/' . str_replace('\\', '/', $path) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }

    // Pour Masterminds\ (html5-php)
    if (0 === strpos($class, 'Masterminds\\')) {
        $path = substr($class, strlen('Masterminds\\'));
        $file = $root . '/lib/html5/src/' . str_replace('\\', '/', $path) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }

    return false;
});

// Charge manuellement la classe Cpdf (non namespacée, utilisée par Dompdf)
if (file_exists($root . '/lib/Cpdf.php')) {
    require_once $root . '/lib/Cpdf.php';
}