<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'vendor/autoload.php'; // Charge l'autoloader (ajustez si nécessaire)

use Dompdf\Dompdf;

// Générez le contenu HTML de la facture avec plus de détails et un meilleur style
$html = '
<html>
    <head>
        <style>
            @page { margin: 20mm 15mm 20mm 15mm; } /* Marges pour le PDF */
            body { 
                font-family: Arial, sans-serif; 
                font-size: 12pt; 
                color: #333; 
                line-height: 1.4; 
            }
            .header { 
                text-align: center; 
                border-bottom: 2px solid #007bff; 
                padding-bottom: 10px; 
                margin-bottom: 20px; 
            }
            .header h1 { 
                font-size: 24pt; 
                color: #007bff; 
                margin: 0; 
            }
            .info-societe { 
                float: left; 
                width: 50%; 
            }
            .info-client { 
                float: right; 
                width: 40%; 
                text-align: right; 
            }
            .clearfix { clear: both; }
            table { 
                width: 100%; 
                border-collapse: collapse; 
                margin: 20px 0; 
            }
            th { 
                background-color: #007bff; 
                color: white; 
                padding: 8px; 
                text-align: left; 
            }
            td { 
                border: 1px solid #ddd; 
                padding: 8px; 
            }
            .total { 
                text-align: right; 
                font-weight: bold; 
                background-color: #f8f9fa; 
            }
            .footer { 
                margin-top: 30px; 
                text-align: center; 
                font-size: 10pt; 
                color: #666; 
                border-top: 1px solid #ddd; 
                padding-top: 10px; 
            }
        </style>
    </head>
    <body>
        <div class="header">
            <h1>Facture N°456</h1>
            <p>Date : ' . date('d/m/Y') . '</p>
        </div>
        
        <div class="info-societe">
            <strong>Ma Société SARL</strong><br>
            Adresse : 123 Rue Exemple<br>
            75001 Paris, France<br>
            Téléphone : 01 23 45 67 89<br>
            Email : contact@masociete.fr
        </div>
        
        <div class="info-client">
            <strong>Client : Jane Smith</strong><br>
            Adresse : 456 Avenue Démo<br>
            69001 Lyon, France<br>
            Téléphone : 04 56 78 90 12<br>
            Email : jane.smith@email.com
        </div>
        
        <div class="clearfix"></div>
        
        <table>
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Quantité</th>
                    <th>Prix Unitaire</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Produit A - Description détaillée</td>
                    <td>2</td>
                    <td>50€</td>
                    <td>100€</td>
                </tr>
                <tr>
                    <td>Produit B - Autre article</td>
                    <td>1</td>
                    <td>100€</td>
                    <td>100€</td>
                </tr>
                <tr>
                    <td>Service C - Prestation supplémentaire</td>
                    <td>3</td>
                    <td>30€</td>
                    <td>90€</td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" class="total">Sous-total :</td>
                    <td>290€</td>
                </tr>
                <tr>
                    <td colspan="3" class="total">TVA (20%) :</td>
                    <td>58€</td>
                </tr>
                <tr>
                    <td colspan="3" class="total">Total TTC :</td>
                    <td>348€</td>
                </tr>
            </tfoot>
        </table>
        
        <div class="footer">
            SIRET : 123 456 789 00012 - APE : 6201Z<br>
            Conditions de paiement : 30 jours net. Tout retard entraînera des pénalités.<br>
            Merci pour votre confiance !
        </div>
    </body>
</html>';

// Initialisez Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html);

// Définissez les options
$dompdf->setPaper('A4', 'portrait');

// Rendu du PDF
$dompdf->render();

// Envoi au navigateur pour téléchargement
$dompdf->stream('facture_avancee.pdf', array('Attachment' => 1));

// Optionnel : Enregistrer sur le serveur
// file_put_contents('archives/facture_456.pdf', $dompdf->output());
?>