<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'vendor/autoload.php'; // Charge Composer (après installation de Dompdf)

use Dompdf\Dompdf;

// Récupérez ou générez le contenu HTML de votre facture
// Par exemple, si c'est déjà dans une variable ou un fichier :
$html = '<html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; }
            .facture { border: 1px solid #000; padding: 20px; }
        </style>
    </head>
    <body>
        <div class="facture">
            <h1>Facture N°123</h1>
            <p>Date : ' . date('d/m/Y') . '</p>
            <p>Client : John Doe</p>
            <!-- Ajoutez ici le contenu dynamique de votre facture PHP -->
            <table>
                <tr><th>Article</th><th>Prix</th></tr>
                <tr><td>Produit 1</td><td>50€</td></tr>
                <!-- ... -->
            </table>
            <p>Total : 150€</p>
        </div>
    </body>
</html>';

// Initialisez Dompdf
$dompdf = new Dompdf();
$dompdf->loadHtml($html); // Charge le HTML

// (Optionnel) Définissez les options, comme le format de papier
$dompdf->setPaper('A4', 'portrait');

// Rendez le PDF
$dompdf->render();

// Pour l'envoi direct au navigateur (téléchargement ou affichage)
$dompdf->stream('facture.pdf', array('Attachment' => 1)); // Attachment=1 pour téléchargement, 0 pour affichage inline

// Ou pour enregistrer sur le serveur pour archivage :
// file_put_contents('archives/facture_123.pdf', $dompdf->output());
?>