<?php
// compteur_simple.php
// Version 2.1 (2025) — corrigée et modernisée par ChatGPT
// Basé sur le script original de Maxou.fr

// ⚙️ Configuration base de données
$ParamGlobal = [
    'Base_Hote'        => '****************',
    'Base_Utilisateur' => '****************',
    'Base_MotDePasse'  => '****************',
    'Base_Base'        => '****************'
];
$table = "test";

// Connexion à la base
$link = mysqli_connect(
    $ParamGlobal['Base_Hote'],
    $ParamGlobal['Base_Utilisateur'],
    $ParamGlobal['Base_MotDePasse'],
    $ParamGlobal['Base_Base']
);
if (mysqli_connect_errno()) exit();

// Encodage
mysqli_set_charset($link, "utf8mb4");

// Variables principales
$file            = basename(__FILE__);
$source          = basename($_SERVER['PHP_SELF']);
$date_quantieme  = date('Ymd');
$table_ip        = $table . "_ip";
$heure_actuelle  = date('H') . "h"; // → "00h", "01h", ..., "23h"

// ==================================================
// Création automatique des tables si besoin
// ==================================================
mysqli_query($link, "
CREATE TABLE IF NOT EXISTS `$table` (
  `quantieme` INT(8) NOT NULL,
  " . implode(", ", array_map(fn($h) => sprintf("`%02dh` INT(11) NOT NULL DEFAULT 0", $h), range(0, 23))) . ",
  `total_j` INT(11) NOT NULL DEFAULT 0,
  `total` INT(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`quantieme`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
");

mysqli_query($link, "
CREATE TABLE IF NOT EXISTS `$table_ip` (
  `ip` VARCHAR(50) NOT NULL,
  `date` INT(8) NOT NULL,
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
");

// ==================================================
// Fonction IP
// ==================================================
function get_client_ip(): string {
    foreach ([
        'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED',
        'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR'
    ] as $key) {
        if (!empty($_SERVER[$key])) {
            return explode(',', $_SERVER[$key])[0];
        }
    }
    return 'UNKNOWN';
}

// ==================================================
// Si le script est inclus dans une autre page → compteur
// ==================================================
if ($source !== $file) {

    // Récupère la ligne du jour
    $stmt = mysqli_prepare($link, "SELECT total FROM `$table` WHERE quantieme = ?");
    mysqli_stmt_bind_param($stmt, "i", $date_quantieme);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $row = mysqli_fetch_assoc($result);
    mysqli_stmt_close($stmt);

    // Si pas encore de ligne pour aujourd’hui → on crée
    if (!$row) {
        $res = mysqli_query($link, "SELECT total FROM `$table` ORDER BY quantieme DESC LIMIT 1");
        $prev = ($r = mysqli_fetch_assoc($res)) ? $r['total'] : 0;
        mysqli_free_result($res);

        $placeholders = implode(",", array_fill(0, 24, 0));
        mysqli_query($link, "INSERT INTO `$table` VALUES ($date_quantieme, $placeholders, 0, $prev)");
    }

    // Nettoyage IP anciennes
    $stmt = mysqli_prepare($link, "DELETE FROM `$table_ip` WHERE date < ?");
    mysqli_stmt_bind_param($stmt, "i", $date_quantieme);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    // Vérifie si IP déjà vue aujourd’hui
    $ip = get_client_ip();
    $stmt = mysqli_prepare($link, "SELECT ip FROM `$table_ip` WHERE ip = ?");
    mysqli_stmt_bind_param($stmt, "s", $ip);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $exists = mysqli_num_rows($res) > 0;
    mysqli_stmt_close($stmt);

    if (!$exists) {
        // Enregistre l'IP
        $stmt = mysqli_prepare($link, "INSERT INTO `$table_ip` (ip, date) VALUES (?, ?)");
        mysqli_stmt_bind_param($stmt, "si", $ip, $date_quantieme);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        // Incrémente le compteur de l’heure actuelle
        mysqli_query($link, "
            UPDATE `$table`
            SET `$heure_actuelle` = `$heure_actuelle` + 1,
                total_j = total_j + 1,
                total = total + 1
            WHERE quantieme = $date_quantieme
        ");
    }

    // Affiche le compteur
    $res = mysqli_query($link, "SELECT total FROM `$table` WHERE quantieme = $date_quantieme");
    $total = ($r = mysqli_fetch_assoc($res)) ? $r['total'] : 0;
    mysqli_free_result($res);

    $mot = ($total <= 1) ? "visiteur" : "visiteurs";
    echo "<a href='$file' target='_blank'>$total $mot</a>";

    mysqli_close($link);
    return; // ⚠️ ne pas utiliser exit()
}

// ==================================================
// Si on appelle directement le script → statistiques
// ==================================================
$stats = $_GET['stats'] ?? 7;
$stats_texte = ($stats === 'total') ? "globales" : "des $stats derniers jours";
$limit = ($stats === 'total') ? "" : "LIMIT " . intval($stats);

// Total du jour
$res = mysqli_query($link, "SELECT total FROM `$table` WHERE quantieme = $date_quantieme");
$total = ($r = mysqli_fetch_assoc($res)) ? $r['total'] : 0;
mysqli_free_result($res);
$mot = ($total <= 1) ? "visiteur" : "visiteurs";

// Récupère les stats
$res = mysqli_query($link, "SELECT * FROM `$table` ORDER BY quantieme DESC $limit");
$data = mysqli_fetch_all($res, MYSQLI_ASSOC);
mysqli_free_result($res);

// ==================================================
// HTML affichage
// ==================================================
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Statistiques du site</title>
<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f8fafc; color: #222; }
table { border-collapse: collapse; width: 100%; font-size: 13px; margin-top: 20px; }
td, th { border: 1px solid #ccc; padding: 4px; text-align: center; }
th { background: #e2e8f0; }
a { color: #2563eb; text-decoration: none; }
a:hover { text-decoration: underline; }
</style>
</head>
<body>
<h2>📊 Statistiques du site</h2>
<p>À ce jour : <strong><?= $total . ' ' . $mot ?></strong></p>
<p>Statistiques <?= htmlspecialchars($stats_texte) ?> :</p>

<table>
<tr>
    <th>Date</th>
    <?php foreach (range(0, 23) as $h): ?>
        <th><?= sprintf('%02d', $h) ?>h</th>
    <?php endforeach; ?>
    <th>Total</th>
</tr>

<?php foreach ($data as $row): ?>
    <tr>
        <td><?= substr($row['quantieme'],6,2)."/".substr($row['quantieme'],4,2)."/".substr($row['quantieme'],0,4) ?></td>
        <?php foreach (range(0, 23) as $h): ?>
            <td><?= $row[sprintf('%02d', $h).'h'] ?></td>
        <?php endforeach; ?>
        <td><?= $row['total_j'] ?></td>
    </tr>
<?php endforeach; ?>
</table>

<br>
<a href="<?= $file ?>">7 jours</a> |
<a href="<?= $file ?>?stats=15">15 jours</a> |
<a href="<?= $file ?>?stats=30">30 jours</a> |
<a href="<?= $file ?>?stats=total">toutes les archives</a>

<br><br>
<small>© 2017–<?= date('Y') ?> <a href="http://scripts.maxou.fr/" target="_blank">scripts.maxou.fr</a></small>
</body>
</html>
<?php
mysqli_close($link);
?>
